/*
* mhal_sata_host_ahci.c - Sigmastar
*
* Copyright (C) 2018 Sigmastar Technology Corp.
*
* Author: edie.chen <edie.chen@sigmastar.com.tw>
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
*/

#include <linux/kernel.h>
#include <asm/io.h>
#include <linux/delay.h>
#include "ms_platform.h"
#include "mdrv_types.h"
#include "mhal_sata_host.h"
#include "mhal_sata_host_ahci.h"

//#define USE_MIPSPLL

#if 0
static void ss_sata_clk_enable(void)
{
    // Enable Clock, bank is chip dependent
    writew(0x000c, (volatile void *)SSTAR_RIU_BASE + (0x100b64 << 1)); // [0] gate
    // [1] clk invert
    // [4:2] 0:240M, 1:216M, [3:clk_miu]
}
#endif
#if 0
static void ss_sata_clk_disable(void)
{
    MHal_SATA_Clock_Config(SATA_MISC_0_ADDRESS_START, SATA_GHC_0_P0_ADDRESS_START, FALSE);
}
#endif

void ss_sata_misc_init(void *mmio, int phy_mode, int n_ports)
{
    void __iomem *port_base = mmio + 0x100;   //1A2880<<2
    void __iomem *misc_base = mmio - 0xA0600; //152500<<2
    u32 u32Temp;

    MHal_SATA_Clock_Config((phys_addr_t)misc_base, (phys_addr_t)port_base, TRUE);

#if 1
    u32Temp = readl((volatile void *)port_base + 0x2c);
    u32Temp = u32Temp & (~E_PORT_SPEED_MASK);
    if(phy_mode == 0)
    {
        u32Temp = u32Temp | E_PORT_SPEED_GEN1;
    }
    else if(phy_mode == 1)
    {
        u32Temp = u32Temp | E_PORT_SPEED_GEN2;
    }
    else if(phy_mode == 2)
    {
        u32Temp = u32Temp | E_PORT_SPEED_GEN3;
    }
    else
    {
        u32Temp = u32Temp | MHal_SATA_get_max_speed();
    }

    writel(u32Temp, (volatile void *)port_base + 0x2c);
    u32Temp = readl((volatile void *)port_base + 0x2c);

    printk("MAC SATA SPEED= 0x%x\n", u32Temp);
#endif
}

void ss_sata_phy_init(void *mmio, int phy_mode, int n_ports)
{
    //phys_addr_t hba_base = (phys_addr_t)mmio; //1A2800<<1
    phys_addr_t port_base = (phys_addr_t)(mmio + 0x100); //1A2880<<1
    u32 GHC_PHY_ANA = 0x0;
    u16 u16Temp;

    if ((n_ports < 1) || (n_ports > 4))
        pr_err("ERROR: PORT num you set is WRONG!!!\n");

    if(port_base == SATA_GHC_0_P0_ADDRESS_START)
    {
        GHC_PHY_ANA = SATA_GHC_0_PHY_ANA;//0x152700
    }

    //printk("sata phy init  A\n");

    //*** Bank 0x1527 h0020 => 0x0100
    writew(0x0100,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_REG_20 << 1));

    //*** Bank 0x1527 h0030 => 0x1000
    writew(0x1000,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_REG_30 << 1));

    //*** Bank 0x1527 h0033 => 0x0500
    writew(0x0500,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_REG_33 << 1));

    //*** Bank 0x1527 h0060 => 0x0002
    writew(0x0002,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_TXPLL_DET_SW << 1));

    //*** Bank 0x1527 h0070 => 0x0062
    writew(0x0062,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_REG_70 << 1));

    //*** Bank 0x1527 h003E => 0x8000
    writew(0x8000,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_REG_3E << 1));
#ifdef USE_MIPSPLL
    //*** Bank 0x1032 h0011 => enable bit11
    u16Temp = readw((volatile void *)SSTAR_RIU_BASE + ((0x103200 + (0x11<<1)) << 1));
    u16Temp |= 0x0800;
    printk("Bank 0x1032 0x11 = 0x%x\n", u16Temp);
    writew(u16Temp, (volatile void *)SSTAR_RIU_BASE + ((0x103200 + (0x11<<1)) << 1));

    //*** Bank 0x1527 h0004 => 0x0000
    writew(0x0000,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_CLK_PMALIVE_SEL << 1));
#else
    //*** Bank 0x1527 h0004 => 0x0002
    writew(0x0002,  (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_CLK_PMALIVE_SEL << 1));
#endif

    //*** Bank 0x1527 h0044 => set bit 0
    u16Temp = readw((volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_SYNTH_SLD << 1));
    u16Temp |= 0x1;
    writew(u16Temp, (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_SYNTH_SLD << 1));
    u16Temp &= ~0x1;
    writew(u16Temp, (volatile void *)SSTAR_RIU_BASE + (REG_SATA_PHY_SYNTH_SLD << 1));

    //*** Bank 0x1527 h0005 => 0x00:Gen1, 0x01:Gen2, 0x10:Gen3
    switch (phy_mode)
    {
        case 0:
            writew(0x00, (volatile void *)SSTAR_RIU_BASE + ((GHC_PHY_ANA + (0x5 << 1)) << 1));
            break;
        case 1:
            writew(0x01, (volatile void *)SSTAR_RIU_BASE + ((GHC_PHY_ANA + (0x5 << 1)) << 1));
            break;
        case 2:
        default:
            writew(0x02, (volatile void *)SSTAR_RIU_BASE + ((GHC_PHY_ANA + (0x5 << 1)) << 1));
            break;
    }
}
